-- events for developer menu

function OnLoad ()
	SetProperty ("/Options:enter_trans_duration", 0.3);
	SetProperty ("/Options:leave_trans_duration", 0.3);
	CacheSound ("ui/sfx/panel_move.ogg");
end;


function OnEnter ()
	PlaySound ("ui/sfx/panel_move.ogg");
end;

function OnLeave ()
    
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Ok") then
	    PlaySound ("ui/sfx/panel_move.ogg");
		PopScreen ("Developer");
		return;
	end;
	
	if (name == "minigame") then
		SwitchScreen ("ColorSweep");
		return;
	end;
	
	if (name == "minigamecomp") then
		SwitchScreen ("HiddenObjectCompleted");
		return;
	end;
	
	if (name == "SurvivalMode") then
		SwitchScreen ("SurvivalMode");
		return;
	end;
	
	if (name == "shaman") then
		PushScreen ("ShamanEditor");
		return;
	end;
	
	if (name == "talisman") then
		PushScreen ("Talisman");
		return;
	end;
	
	if (name == "NewArea") then
		PushScreen ("NewArea");
		return;
	end;
	
	if (name == "trophy") then
		PushScreen ("TrophyAwarded");
		return;
	end;
	
	if (name == "complete") then
		PushScreen ("GameComplete");
		return;
	end;
	
	if (name == "story") then
		PushScreen ("Storyscreen");
		return;
	end;

end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 200);
	SetProperty ("panel:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));

end;

function OnDraw ()

end;
